using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Linq;
using System.Linq.Expressions;

namespace PI.ZB.N1200.ELearning.WinForms.Class
{
    public partial class UCClassList : PI.FM.N000.Base.WinForms.Controls.UCBOList<BL.BO.View.Class, UCClassDetails, BL.BO.Class.Search>
    {
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private PI.FM.N005.VariableRepository.BL.VariableRepository _blVariableRepository = null;

        public UCClassList()
        {
            InitializeComponent();
        }

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        internal PI.FM.N005.VariableRepository.BL.VariableRepository BLVariableRepository
        {
            get
            {
                if (_blVariableRepository == null)
                {
                    _blVariableRepository = new PI.FM.N005.VariableRepository.BL.VariableRepository(Environment);
                }

                return _blVariableRepository;
            }
        }

        protected override void InitAll()
        {
            base.InitAll();
            

            DataManager.AllowedActions = Gemini.Core.WinForms.Controls.Type.ControlActionType.Refresh | Gemini.Core.WinForms.Controls.Type.ControlActionType.RefreshCurrent |  Gemini.Core.WinForms.Controls.Type.ControlActionType.Search;
            DataManager.InitColumns(new string[] { "ID", "Name", "SchoolYear", "SchoolName" });//Przetumaczone
            DataManager.ColumnCaptions = new string[] { Gemini.Dictionary.Text.Grid.ID.Value, Gemini.Dictionary.Text.Grid.Name.Value, BL.Dictionary.Text.Grid.SchoolYear.Name.Value, BL.Dictionary.Text.Grid.School.SchoolName.Value };
        }

        protected override void OnSearch(Gemini.Core.WinForms.Controls.GDataManagerArgs<BL.BO.View.Class> Args)
        {
            FClassSearch _fSearch = new FClassSearch();
            _fSearch.Initialize(Plugin, Environment);
            _fSearch.Search = DataManager.CurrentSearchCriteria;

            if (_fSearch.ShowDialog() == DialogResult.OK)
            {
                DataManager.CurrentSearchCriteria = _fSearch.Search;
                DataManager.LoadData();
            }
        }

        protected override IList<BL.BO.View.Class> OnLoadData(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            DataManager.TotalCount = BLZSBELearning.Instructor.Count();

            return BLZSBELearning.Class.View.Restore(DataManager.CurrentSearchCriteria);
        }

        protected override void OnSave(Gemini.Core.WinForms.Controls.GDataManagerArgs<BL.BO.View.Class> Args)
        {
        }

        protected override BL.BO.View.Class OnCreate(Gemini.Core.WinForms.Controls.GDataManagerArgs Args)
        {
            return null;
        }

        protected override BL.BO.View.Class DoRestoreCurrent(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
        {
            return BLZSBELearning.Class.View.Restore(BO);
        }

        public override void DialogResultOK()
        {
            Param.Object = DataManager.Current;
            Param.ObjectTitle = DataManager.Current.DisplayValue;
            Param.ObjectID = DataManager.Current.ID;
            Param.IsObjectValid = true;
            Param.ClientID = BLZSBELearning.ClientID;
            Param.ObjectList = DataManager.GetSelectedObjects().Select(x => (FM.N000.Base.BL.BO.Base)x).ToList();
        }
    }
}
